<?php

class richcontentozon {
    const imagePathName = "/images/"; // папка в которую загружаются файлы из конструктора рич контента V 0.3
    const backgroundColor = "#FFFFFF";

    private $imagePath = "";
    private $urlPrefix = "";
    private $result = array();
    private $fileData = null;
    private $type = null;
    private $scriptPathName = "";
    private $scriptUrlSetupPath = "";
    private $checkImagePerm = array();
    private $setup = 0;

    public function __construct($setup = 0) {
        if ($setup===1) {
            $this->setup = 1;
            header('Content-Type: text/html; charset=utf-8');
        } else {
            header("Content-type: application/json; charset=utf-8");
        }
        self::getPath();
        self::getUrl();
        self::parseQuery();
    }

    public function getSetup () {
        self::checkWrite();
        return array(
            "SetupPath"  => $this->scriptUrlSetupPath,
            "checkWrite"  => $this->checkImagePerm
        );
    }

    public function getResult () {
        return self::prepareResponce();
    }

    private function getPath () {
        $IMAGES_FOLDER = __DIR__.self::imagePathName;
        $this->imagePath = $IMAGES_FOLDER;
        $urlArray = explode("/",$_SERVER['SCRIPT_URL']);
        if (is_array($urlArray) && count($urlArray)>0) {
            array_pop($urlArray);
        }
        $this->scriptPathName = implode("/",$urlArray);
    }

    private function getUrl () {
        $HTTP_HOST = getenv("HTTP_HOST");
        $this->urlPrefix = "https://".$HTTP_HOST.$this->scriptPathName.self::imagePathName;
        $this->scriptUrlSetupPath =  "https://".$HTTP_HOST.$this->scriptPathName."/reception.php";
    }

    private function checkWrite () {
        $tempFile = "check.dat";
        if (file_put_contents($this->imagePath.$tempFile,"")===false) {
            $this->result = array(
                "message" => "Ошибка. На папку ".self::imagePathName." не установлены права на запись.",
                "error" => true
            );
            if ($this->setup === 1) {
                $this->checkImagePerm = $this->result;
            }
        } else {
            unlink($this->imagePath.$tempFile);
            $this->result = array(
                "message" => "На папку ".self::imagePathName." установлены верные права на запись.",
                "error" => false
            );
            if ($this->setup === 1) {
                $this->checkImagePerm = $this->result;
            }
        }
    }

    public function prepareResponce () {
        return json_encode($this->result,JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }

    public function parseQuery () {
        if (isset($_POST['checkfolderperm'])) {
            self::checkWrite();
        }
        if (isset($_POST['getspace'])) {
            self::getDiscSpace();
        }
        if (isset($_POST['file'])) {
            $this->fileData = $_POST['file'];
            $this->type = $_POST['type'];
            self::upload();
        }
    }

    private function getDiscSpace () {
        $bytes = disk_free_space($this->imagePath);
        $si_prefix = array( 'B', 'KB', 'MB', 'GB', 'TB', 'EB', 'ZB', 'YB' );
        $base = 1024;
        $class = min((int)log($bytes , $base) , count($si_prefix) - 1);
        $this->result = array(
            "message" => sprintf('%1.2f' , $bytes / pow($base,$class)) . ' ' . $si_prefix[$class],
            "error" => false
        );
    }

    private function upload () {
        $foo = new upload('data:'.$this->fileData);
        $foo->allowed = array('image/*');
        $foo_file_src_ext = mb_strtolower($foo->file_src_name_ext);
        if (!in_array($foo_file_src_ext,array("png"))) {
            $foo->image_convert = 'png';
        }
        if ($foo->uploaded) {
            try {
                $foo->allowed = array('image/*');
                $foo_file_src_ext = mb_strtolower($foo->file_src_name_ext);
                if (!in_array($foo_file_src_ext,array("png"))) {
                    $foo->image_convert = 'png';
                }
                $sourseWidth = $foo->image_src_x;
                $sourseHeight = $foo->image_src_y;
                $foo->file_new_name_body   = uniqid('_richcontentozon.ru__',true);
                if ($this->type=="bannerbygtext") {
                    if ($sourseWidth!=1416 || $sourseHeight!=708) {
                        $foo->image_x               = 1416;
                        $foo->image_y               = 708;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="bannerbyg") {
                    if ($sourseWidth!=1416 || $sourseHeight!=708) {
                        $foo->image_x               = 1416;
                        $foo->image_y               = 708;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="bannersmalltext") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="bannersmall") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="cheezshahmat") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="fourblesmall") {
                    if ($sourseWidth!=55 || $sourseHeight!=55) {
                        $foo->image_x               = 55;
                        $foo->image_y               = 55;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="fourblebig") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="trible") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="double") {
                    if ($sourseWidth!=777 || $sourseHeight!=777) {
                        $foo->image_x               = 777;
                        $foo->image_y               = 777;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="listimageli") {
                    if ($sourseWidth!=50 || $sourseHeight!=50) {
                        $foo->image_x               = 50;
                        $foo->image_y               = 50;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                if ($this->type=="tablicaimage") {
                    if ($sourseWidth!=440 || $sourseHeight!=440) {
                        $foo->image_x               = 440;
                        $foo->image_y               = 440;
                        $foo->image_resize          = true;
                        $foo->image_ratio_fill      = true;
                    }
                }
                $foo->process($this->imagePath);
                if ($foo->processed) {
                    $this->result = array(
                        "error" => false,
                        "imageUrl" => $this->urlPrefix.$foo->file_dst_name.'',
                        "filePathDelete" => $foo->file_dst_name,
                        "pos" => 1,
                        "count" => 1,
                    );
                } else {
                    $this->result = array(
                        "error" => true,
                    );
                }
            } catch (\Exception $e) {
                $this->result = array(
                    "error" => true,
                    "message" => $e->getMessage(),
                );
            }
        }
    }
}